@extends('backend.admin-master')

@section('site-title')
    {{ __('Topbar Settings') }}
@endsection
@section('content')
    <div class="col-lg-12 col-ml-12 padding-bottom-30">
        <div class="row">
            <div class="col-lg-12">
                <div class="margin-top-40"></div>
                @include('backend.partials.message')
                @include('backend.partials.error')
            </div>
            <div class="col-lg-6 mt-5">
                <div class="card">
                    <div class="card-body">
                        <h4 class="header-title">{{ __('Topbar info item Settings') }}</h4>
                        <form action="{{ route('admin.topbar.info.item.store') }}" method="post" enctype="multipart/form-data">
                            @csrf
                            <div class="iconbox-repeater-wrapper">
                                <div class="all-field-wrap">
                                    <div class="tab-content margin-top-30" id="myTabContent">
                                        <div class="form-group">
                                            <label for="navbar_right_text">{{ __('Text') }}</label>
                                            <input type="text" name="navbar_right_text" class="form-control" value="{{ get_static_option('navbar_right_text') }}">
                                        </div>
                                        <div class="form-group">
                                            <label for="navbar_right_info">{{ __('Info') }}</label>
                                            <input type="text" name="navbar_right_info" class="form-control" value="{{ get_static_option('navbar_right_info') }}">
                                        </div>
                                    </div>
                                    <div class="tab-content margin-top-30" id="myTabContent">
                                        <div class="form-group">
                                            <label for="navbar_right_text">{{ __('Faq Text') }}</label>
                                            <input type="text" name="navbar_right_faq_text" class="form-control" value="{{ get_static_option('navbar_right_faq_text') }}">
                                        </div>
                                        <div class="form-group">
                                            <label for="navbar_right_info">{{ __('Faq URL') }}</label>
                                            <input type="text" name="navbar_right_faq_url" class="form-control" value="{{ get_static_option('navbar_right_faq_url') }}">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <button id="update" type="submit" class="btn btn-primary mt-4 pr-4 pl-4">{{ __('Update Settings') }}</button>
                        </form>
                    </div>
                </div>
            </div>

            <div class="col-lg-6 mt-5">
                <div class="card">
                    <div class="card-body">
                        <h4 class="header-title">{{ __('Social Icons') }}</h4>
                        <div class="right-cotnent margin-bottom-40"><a class="btn btn-primary"
                                data-target="#add_social_icon" data-toggle="modal"
                                href="#">{{ __('Add New Social Item') }}</a></div>
                        <table class="table table-default">
                            <thead>
                                <th>{{ __('ID') }}</th>
                                <th>{{ __('Icon') }}</th>
                                <th>{{ __('URL') }}</th>
                                <th>{{ __('Action') }}</th>
                            </thead>
                            <tbody>
                                @foreach ($all_social_icons as $data)
                                    <tr>
                                        <td>{{ $data->id }}</td>
                                        <td><i class="{{ $data->icon }}"></i></td>
                                        <td>{{ $data->url }}</td>
                                        <td>
                                            <x-delete-popover :url="route('admin.delete.social.item', $data->id)" />
                                            <a href="#" data-toggle="modal" data-target="#social_item_edit_modal"
                                                class="btn btn-xs btn-primary  mb-3 mr-1 social_item_edit_btn"
                                                data-id="{{ $data->id }}" data-url="{{ $data->url }}"
                                                data-icon="{{ $data->icon }}">
                                                <i class="ti-pencil"></i>
                                            </a>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="add_social_icon" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">{{ __('Add Social Item') }}</h5>
                    <button type="button" class="close" data-dismiss="modal"><span>×</span></button>
                </div>
                <form action="{{ route('admin.new.social.item') }}" method="post">
                    <div class="modal-body">
                        @csrf
                        <div class="form-group">
                            <label for="icon" class="d-block">{{ __('Icon') }}</label>
                            <div class="btn-group ">
                                <button type="button" class="btn btn-primary iconpicker-component">
                                    <i class="fas fa-exclamation-triangle"></i>
                                </button>
                                <button type="button" class="icp icp-dd btn btn-primary dropdown-toggle"
                                    data-selected="fas fa-exclamation-triangle" data-toggle="dropdown">
                                    <span class="caret"></span>
                                    <span class="sr-only">{{ __('Toggle Dropdown') }}</span>
                                </button>
                                <div class="dropdown-menu"></div>
                            </div>
                            <input type="hidden" class="form-control" id="icon" value="fas fa-exclamation-triangle"
                                name="icon">
                        </div>
                        <div class="form-group">
                            <label for="social_item_link">{{ __('URL') }}</label>
                            <input type="text" name="url" id="social_item_link" class="form-control">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">{{ __('Close') }}</button>
                        <button id="submit" type="submit" class="btn btn-primary">{{ __('Add Social Item') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="social_item_edit_modal" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">{{ __('Edit Social Item') }}</h5>
                    <button type="button" class="close" data-dismiss="modal"><span>×</span></button>
                </div>
                <form action="{{ route('admin.update.social.item') }}" method="post">
                    <div class="modal-body">
                        @csrf
                        <input type="hidden" name="id" id="social_item_id" value="">

                        <div class="form-group">
                            <label for="icon" class="d-block">{{ __('Icon') }}</label>
                            <div class="btn-group ">
                                <button type="button" class="btn btn-primary iconpicker-component">
                                    <i class="fas fa-exclamation-triangle"></i>
                                </button>
                                <button type="button" class="icp icp-dd btn btn-primary dropdown-toggle" data-selected="fas fa-exclamation-triangle" data-toggle="dropdown">
                                    <span class="caret"></span>
                                    <span class="sr-only">{{ __('Toggle Dropdown') }}</span>
                                </button>
                                <div class="dropdown-menu"></div>
                            </div>
                            <input type="hidden" class="form-control" id="icon" value="fas fa-exclamation-triangle" name="icon">
                        </div>
                        <div class="form-group">
                            <label for="social_item_edit_url">{{ __('Url') }}</label>
                            <input type="text" class="form-control" id="social_item_edit_url" name="url" placeholder="{{ __('Url') }}">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">{{ __('Close') }}</button>
                        <button id="update" type="submit" class="btn btn-primary">{{ __('Save Changes') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@section('script')
    <x-repeater />
    <script>
        (function($) {
            "use strict";
            $(document).ready(function() {
                <x-btn.submit/>
                <x-btn.update />

                $(document).on('click', '.social_item_edit_btn', function() {
                    var el = $(this);
                    var id = el.data('id');
                    var url = el.data('url');
                    var icon = el.data('icon');
                    var form = $('#social_item_edit_modal');
                    form.find('#social_item_id').val(id);
                    form.find('#social_item_edit_icon').val(icon);
                    form.find('#social_item_edit_url').val(url);
                    form.find('.icp-dd').attr('data-selected', el.data('icon'));
                    form.find('.iconpicker-component i').attr('class', el.data('icon'));
                });

                $('.icp-dd').iconpicker();
                $('.icp-dd').on('iconpickerSelected', function(e) {
                    var selectedIcon = e.iconpickerValue;
                    $(this).parent().parent().children('input').val(selectedIcon);
                });
                $('.icp-dd').iconpicker();
                $('body').on('iconpickerSelected', '.icp-dd', function(e) {
                    var selectedIcon = e.iconpickerValue;
                    $(this).parent().parent().children('input').val(selectedIcon);
                    $('body .dropdown-menu.iconpicker-container').removeClass('show');
                });
            }) //document ready close
        })(jQuery);
    </script>
@endsection
