<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Language;
use Illuminate\Http\Request;

class ContactPageController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:admin');
        $this->middleware('permission:page-settings-contact-page-manage');
    }
    public function contact_page_form_area()
    {
        return view('backend.pages.contact-page.form-section');
    }
    public function contact_page_update_form_area(Request $request)
    {
        $this->validate($request, [
            'contact_page_form_receiving_mail' => 'nullable|string'
        ]);

        $this->validate($request, [
            'contact_page_form_section_title' => 'nullable|string',
            'contact_page_form_submit_btn_text' => 'nullable|string',
        ]);

        $field = 'contact_page_form_section_title';
        $form_submit_btn_text = 'contact_page_form_submit_btn_text';

        update_static_option('contact_page_form_section_title', sanitize_html($request->$field));
        update_static_option('contact_page_form_submit_btn_text', sanitize_html($request->$form_submit_btn_text));

        update_static_option('contact_page_form_receiving_mail', sanitize_html($request->contact_page_form_receiving_mail));

        return redirect()->back()->with(['msg' => __('Settings Updated..'), 'type' => 'success']);
    }
    public function contact_page_map_area()
    {
        return view('backend.pages.contact-page.google-map-section');
    }
    public function contact_page_update_map_area(Request $request)
    {
        $this->validate($request, [
            'contact_page_map_section_location' => 'required|string',
            'contact_page_map_section_zoom' => 'required|string',
        ]);
        update_static_option('contact_page_map_section_location', sanitize_html($request->contact_page_map_section_location));
        update_static_option('contact_page_map_section_zoom', sanitize_html($request->contact_page_map_section_zoom));

        return redirect()->back()->with(['msg' => __('Settings Updated..'), 'type' => 'success']);
    }

    public function contact_page_section_manage()
    {

        return view('backend.pages.contact-page.section-manage');
    }

    public function contact_page_update_section_manage(Request $request)
    {
        $this->validate($request, [
            'contact_page_contact_info_section_status' => 'required|string',
            'contact_page_contact_section_status' => 'required|string',
        ]);
        update_static_option('contact_page_contact_info_section_status', sanitize_html($request->contact_page_contact_info_section_status));
        update_static_option('contact_page_contact_section_status', sanitize_html($request->contact_page_contact_section_status));

        return redirect()->back()->with(['msg' => __('Settings Updated..'), 'type' => 'success']);
    }
}
